<?php
session_start();
require_once __DIR__ . '/includes/ServerMonitor.php';

$monitor = new ServerMonitor();
$currentStats = $monitor->checkResources();
$recentStats = $monitor->getRecentStats(60); // Last hour

// Get current resource usage
$memory = $monitor->getMemoryUsage();
$cpu = $monitor->getCpuUsage();
$disk = $monitor->getDiskUsage();
$activeSessions = $monitor->getActiveSessions();
$tempFiles = $monitor->getTempFileCount();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Server Monitor - Photo Resizer Pro</title>
    <meta http-equiv="refresh" content="30">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f5f5f5;
            padding: 20px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
        }
        
        h1 {
            color: #333;
            margin-bottom: 30px;
            text-align: center;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }
        
        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
        }
        
        .stat-icon {
            font-size: 30px;
            margin-bottom: 10px;
        }
        
        .stat-label {
            color: #666;
            font-size: 14px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 5px;
        }
        
        .stat-value {
            font-size: 32px;
            font-weight: bold;
            color: #333;
            margin-bottom: 5px;
        }
        
        .stat-detail {
            color: #888;
            font-size: 12px;
        }
        
        .progress-bar {
            width: 100%;
            height: 8px;
            background: #e0e0e0;
            border-radius: 4px;
            overflow: hidden;
            margin-top: 10px;
        }
        
        .progress-fill {
            height: 100%;
            background: #4caf50;
            transition: width 0.3s ease;
        }
        
        .progress-fill.warning {
            background: #ff9800;
        }
        
        .progress-fill.danger {
            background: #f44336;
        }
        
        .chart-container {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        
        .refresh-info {
            text-align: center;
            color: #666;
            font-size: 14px;
            margin-top: 20px;
        }
        
        .status-indicator {
            display: inline-block;
            width: 12px;
            height: 12px;
            border-radius: 50%;
            margin-right: 5px;
        }
        
        .status-healthy { background: #4caf50; }
        .status-warning { background: #ff9800; }
        .status-critical { background: #f44336; }
        
        @media (max-width: 768px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🖥️ Server Monitor</h1>
        
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon">💾</div>
                <div class="stat-label">Memory Usage</div>
                <div class="stat-value"><?php echo isset($memory['percent_used']) ? $memory['percent_used'] . '%' : 'N/A'; ?></div>
                <div class="stat-detail">
                    <?php 
                    if (isset($memory['available']) && isset($memory['total'])) {
                        echo round($memory['available'] / 1048576) . ' MB / ' . round($memory['total'] / 1048576) . ' MB';
                    }
                    ?>
                </div>
                <div class="progress-bar">
                    <div class="progress-fill <?php 
                        $percent = $memory['percent_used'] ?? 0;
                        echo $percent > 80 ? 'danger' : ($percent > 60 ? 'warning' : '');
                    ?>" style="width: <?php echo $memory['percent_used'] ?? 0; ?>%"></div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">⚡</div>
                <div class="stat-label">CPU Load</div>
                <div class="stat-value"><?php echo round($cpu['load_1min'] ?? 0, 2); ?></div>
                <div class="stat-detail">
                    1min: <?php echo round($cpu['load_1min'] ?? 0, 2); ?> | 
                    5min: <?php echo round($cpu['load_5min'] ?? 0, 2); ?> | 
                    15min: <?php echo round($cpu['load_15min'] ?? 0, 2); ?>
                </div>
                <div class="progress-bar">
                    <div class="progress-fill <?php 
                        $percent = $cpu['percent_used'] ?? 0;
                        echo $percent > 75 ? 'danger' : ($percent > 50 ? 'warning' : '');
                    ?>" style="width: <?php echo min(100, $cpu['percent_used'] ?? 0); ?>%"></div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">💿</div>
                <div class="stat-label">Disk Usage</div>
                <div class="stat-value"><?php echo $disk['percent_used'] ?? 'N/A'; ?>%</div>
                <div class="stat-detail">
                    <?php 
                    if (isset($disk['free']) && isset($disk['total'])) {
                        echo round($disk['free'] / 1073741824, 1) . ' GB free of ' . 
                             round($disk['total'] / 1073741824, 1) . ' GB';
                    }
                    ?>
                </div>
                <div class="progress-bar">
                    <div class="progress-fill <?php 
                        $percent = $disk['percent_used'] ?? 0;
                        echo $percent > 90 ? 'danger' : ($percent > 75 ? 'warning' : '');
                    ?>" style="width: <?php echo $disk['percent_used'] ?? 0; ?>%"></div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">👥</div>
                <div class="stat-label">Active Sessions</div>
                <div class="stat-value"><?php echo $activeSessions; ?></div>
                <div class="stat-detail">In the last 5 minutes</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">📁</div>
                <div class="stat-label">Temp Files</div>
                <div class="stat-value"><?php echo $tempFiles; ?></div>
                <div class="stat-detail">In temporary directory</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">🚦</div>
                <div class="stat-label">System Status</div>
                <div class="stat-value">
                    <?php 
                    $isHealthy = (!isset($memory['percent_used']) || $memory['percent_used'] < 80) &&
                                (!isset($cpu['percent_used']) || $cpu['percent_used'] < 75) &&
                                (!isset($disk['percent_used']) || $disk['percent_used'] < 90);
                    
                    if ($isHealthy) {
                        echo '<span class="status-indicator status-healthy"></span>Healthy';
                    } else {
                        echo '<span class="status-indicator status-warning"></span>Warning';
                    }
                    ?>
                </div>
                <div class="stat-detail">All systems operational</div>
            </div>
        </div>
        
        <?php if (isset($memory['php_current'])): ?>
        <div class="chart-container">
            <h2>PHP Memory Usage</h2>
            <p>Current: <?php echo round($memory['php_current'] / 1048576, 2); ?> MB</p>
            <p>Peak: <?php echo round($memory['php_peak'] / 1048576, 2); ?> MB</p>
        </div>
        <?php endif; ?>
        
        <div class="refresh-info">
            🔄 This page auto-refreshes every 30 seconds | Last update: <?php echo date('H:i:s'); ?>
        </div>
    </div>
</body>
</html>