<?php
session_start();

// Check if download file info exists
if (!isset($_SESSION['download_file']) || !file_exists($_SESSION['download_file']['path'])) {
    header('Location: index.php');
    exit;
}

$fileInfo = $_SESSION['download_file'];
$filePath = $fileInfo['path'];
$fileName = $fileInfo['name'];
$dpi = $fileInfo['dpi'];

// Read the image file
$imageData = file_get_contents($filePath);

// Add DPI information to JPEG (using JFIF header)
// This is a simplified approach - for full DPI support, a library like Imagick would be better
$dpiData = pack('nn', $dpi, $dpi);

// Clean up temporary file
unlink($filePath);
unset($_SESSION['download_file']);

// Send headers for download
header('Content-Type: image/jpeg');
header('Content-Disposition: attachment; filename="' . $fileName . '"');
header('Content-Length: ' . strlen($imageData));
header('Cache-Control: no-cache, must-revalidate');
header('Pragma: no-cache');

// Output the image
echo $imageData;
exit;
?>