<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
header('Content-Type: application/json');

// Debug info
$debug = [
    'session' => isset($_SESSION['uploaded_image']) ? 'exists' : 'missing',
    'method' => $_SERVER['REQUEST_METHOD'],
    'post_data' => $_POST
];

// Check if image was uploaded
if (!isset($_SESSION['uploaded_image'])) {
    echo json_encode(['error' => 'No image in session', 'debug' => $debug]);
    exit;
}

if (!file_exists($_SESSION['uploaded_image']['path'])) {
    echo json_encode(['error' => 'Image file not found: ' . $_SESSION['uploaded_image']['path'], 'debug' => $debug]);
    exit;
}

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['error' => 'Invalid request method', 'debug' => $debug]);
    exit;
}

// Get parameters
$width = isset($_POST['width']) ? intval($_POST['width']) : 0;
$height = isset($_POST['height']) ? intval($_POST['height']) : 0;
$cropX = isset($_POST['cropX']) ? intval($_POST['cropX']) : 0;
$cropY = isset($_POST['cropY']) ? intval($_POST['cropY']) : 0;
$cropWidth = isset($_POST['cropWidth']) ? intval($_POST['cropWidth']) : 0;
$cropHeight = isset($_POST['cropHeight']) ? intval($_POST['cropHeight']) : 0;
$brightness = isset($_POST['brightness']) ? intval($_POST['brightness']) : 0;
$contrast = isset($_POST['contrast']) ? intval($_POST['contrast']) : 0;
$background = isset($_POST['background']) ? $_POST['background'] : 'none';
$quality = isset($_POST['quality']) ? intval($_POST['quality']) : 85;

$debug['params'] = compact('width', 'height', 'cropX', 'cropY', 'cropWidth', 'cropHeight', 'brightness', 'contrast', 'background', 'quality');

// Validate parameters
if ($width <= 0 || $height <= 0 || $cropWidth <= 0 || $cropHeight <= 0) {
    echo json_encode(['error' => 'Invalid dimensions', 'debug' => $debug]);
    exit;
}

echo json_encode(['success' => true, 'debug' => $debug, 'message' => 'Debug mode - would process image here']);
?>