<?php
session_start();
header('Content-Type: application/json');

try {
    // Define directories to clear
    $directories = [
        __DIR__ . '/temp/rate_limit/',
        __DIR__ . '/temp/ip_rate_limit/',
        __DIR__ . '/temp/queue/'
    ];
    
    $clearedFiles = 0;
    
    foreach ($directories as $dir) {
        if (is_dir($dir)) {
            $files = glob($dir . '*.json');
            foreach ($files as $file) {
                if (unlink($file)) {
                    $clearedFiles++;
                }
            }
        }
    }
    
    // Also clear the current session
    if (isset($_SESSION['rate_limit'])) {
        unset($_SESSION['rate_limit']);
    }
    
    echo json_encode([
        'success' => true,
        'message' => "Successfully cleared $clearedFiles rate limit files",
        'directories' => $directories
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>