<?php
header('Content-Type: text/plain');

echo "PHP Version: " . PHP_VERSION . "\n\n";

echo "GD Library Check:\n";
if (extension_loaded('gd')) {
    echo "GD is installed\n";
    $gd_info = gd_info();
    foreach ($gd_info as $key => $value) {
        echo "  $key: " . ($value === true ? 'Yes' : ($value === false ? 'No' : $value)) . "\n";
    }
} else {
    echo "GD is NOT installed\n";
}

echo "\n\nImage Functions:\n";
$functions = [
    'imagecreatetruecolor',
    'imagecreatefromjpeg',
    'imagecreatefrompng',
    'imagecreatefromgif',
    'imagecopyresampled',
    'imagefilter',
    'imagejpeg',
    'exif_imagetype'
];

foreach ($functions as $func) {
    echo "  $func: " . (function_exists($func) ? 'Available' : 'NOT Available') . "\n";
}

echo "\n\nSession Info:\n";
session_start();
echo "Session ID: " . session_id() . "\n";
echo "Session data: ";
print_r($_SESSION);
?>