<?php
header('Content-Type: application/json');

try {
    // For testing, create a simple 100x100 white image
    $width = 100;
    $height = 100;
    
    $image = imagecreatetruecolor($width, $height);
    if (!$image) {
        throw new Exception('Failed to create test image');
    }
    
    // Fill with white
    $white = imagecolorallocate($image, 255, 255, 255);
    imagefill($image, 0, 0, $white);
    
    // Add some text
    $black = imagecolorallocate($image, 0, 0, 0);
    imagestring($image, 5, 10, 40, 'TEST', $black);
    
    // Output as base64
    ob_start();
    imagejpeg($image, null, 85);
    $imageData = ob_get_clean();
    
    imagedestroy($image);
    
    echo json_encode([
        'success' => true,
        'data' => 'data:image/jpeg;base64,' . base64_encode($imageData),
        'size' => round(strlen($imageData) / 1024, 1)
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}
?>