<?php
session_start();
header('Content-Type: application/json');

// Test if we can process images without exif_imagetype
try {
    // Create a test image
    $testImage = imagecreatetruecolor(200, 200);
    $white = imagecolorallocate($testImage, 255, 255, 255);
    $black = imagecolorallocate($testImage, 0, 0, 0);
    imagefill($testImage, 0, 0, $white);
    imagestring($testImage, 5, 50, 90, 'TEST IMAGE', $black);
    
    // Save to temp file
    $tempFile = __DIR__ . '/temp/test_' . uniqid() . '.jpg';
    imagejpeg($testImage, $tempFile, 90);
    imagedestroy($testImage);
    
    // Test getimagesize
    $imageInfo = getimagesize($tempFile);
    
    // Test loading the image
    $loaded = imagecreatefromjpeg($tempFile);
    if ($loaded) {
        imagedestroy($loaded);
        $canLoad = true;
    } else {
        $canLoad = false;
    }
    
    // Clean up
    unlink($tempFile);
    
    echo json_encode([
        'success' => true,
        'tests' => [
            'create_image' => true,
            'save_image' => true,
            'getimagesize' => $imageInfo !== false,
            'image_type' => $imageInfo[2] ?? null,
            'image_mime' => $imageInfo['mime'] ?? null,
            'load_image' => $canLoad
        ],
        'functions' => [
            'getimagesize' => function_exists('getimagesize'),
            'imagecreatetruecolor' => function_exists('imagecreatetruecolor'),
            'imagecreatefromjpeg' => function_exists('imagecreatefromjpeg')
        ]
    ]);
} catch (Exception $e) {
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}
?>