<?php
session_start();

// Test if session exists
if (!isset($_SESSION['uploaded_image'])) {
    echo json_encode(['error' => 'No image in session']);
    exit;
}

// Test if file exists
if (!file_exists($_SESSION['uploaded_image']['path'])) {
    echo json_encode(['error' => 'Image file not found: ' . $_SESSION['uploaded_image']['path']]);
    exit;
}

// Test basic processing
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = [
        'action' => $_POST['action'] ?? 'none',
        'width' => $_POST['width'] ?? 0,
        'height' => $_POST['height'] ?? 0,
        'session' => $_SESSION['uploaded_image']
    ];
    
    echo json_encode($data);
} else {
    echo json_encode(['method' => $_SERVER['REQUEST_METHOD']]);
}
?>