<?php
session_start();
header('Content-Type: application/json');

try {
    // Check if POST data exists
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }
    
    // Get the image data
    $imageData = isset($_POST['data']) ? $_POST['data'] : '';
    $width = isset($_POST['width']) ? intval($_POST['width']) : 0;
    $height = isset($_POST['height']) ? intval($_POST['height']) : 0;
    $size = isset($_POST['size']) ? $_POST['size'] : '0';
    $quality = isset($_POST['quality']) ? intval($_POST['quality']) : 85;
    
    // Validate data
    if (empty($imageData) || !preg_match('/^data:image\/[a-z]+;base64,/', $imageData)) {
        throw new Exception('Invalid image data');
    }
    
    if ($width <= 0 || $height <= 0) {
        throw new Exception('Invalid dimensions');
    }
    
    // Store in session
    $_SESSION['processed_image'] = [
        'data' => $imageData,
        'width' => $width,
        'height' => $height,
        'size' => $size,
        'quality' => $quality,
        'timestamp' => time()
    ];
    
    echo json_encode(['success' => true]);
    
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>