<?php
session_start();
header('Content-Type: application/json');

require_once __DIR__ . '/includes/ProcessingQueue.php';
require_once __DIR__ . '/includes/RateLimiter.php';

try {
    if (!isset($_GET['queue_id'])) {
        throw new Exception('Queue ID is required');
    }
    
    $queueId = $_GET['queue_id'];
    $queue = new ProcessingQueue();
    
    $status = $queue->getStatus($queueId);
    
    // Add rate limit info
    $rateLimiter = new RateLimiter(10, 60);
    $status['rate_limit'] = [
        'remaining' => $rateLimiter->getRemainingRequests('image_process'),
        'reset_time' => $rateLimiter->getResetTime('image_process')
    ];
    
    echo json_encode([
        'success' => true,
        'data' => $status
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>