<?php
session_start();
header('Content-Type: application/json');

require_once __DIR__ . '/includes/RateLimiter.php';
require_once __DIR__ . '/includes/IPRateLimiter.php';

try {
    // Get session rate limit status
    $rateLimiter = new RateLimiter(2, 60);
    $sessionRemaining = $rateLimiter->getRemainingRequests('image_process');
    $sessionWaitTime = $rateLimiter->getWaitTime('image_process');
    
    // Get IP rate limit status
    $ipLimiter = new IPRateLimiter(2, 5);
    $ipRemaining = $ipLimiter->getRemainingRequests();
    $ipWaitTime = $ipLimiter->getWaitTime();
    $userIP = $ipLimiter->getUserIP();
    $isSuspicious = $ipLimiter->isSuspicious();
    
    echo json_encode([
        'success' => true,
        'session' => [
            'remaining' => $sessionRemaining,
            'max' => 2,
            'waitTime' => $sessionWaitTime,
            'timeWindow' => 60
        ],
        'ip' => [
            'address' => $userIP,
            'minute' => $ipRemaining['minute'],
            'maxMinute' => 2,
            'hour' => $ipRemaining['hour'],
            'maxHour' => 5,
            'waitTime' => $ipWaitTime,
            'suspicious' => $isSuspicious
        ],
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>