<?php
session_start();

// Check if image data exists
if (!isset($_SESSION['processed_image']) || !isset($_SESSION['processed_image']['data'])) {
    header('Location: index.php');
    exit;
}

$imageData = $_SESSION['processed_image'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Download Your Resized Photo - Photo Resizer Pro</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            animation: slideUp 0.5s ease-out;
        }
        
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        h1 {
            text-align: center;
            color: #333;
            margin-bottom: 10px;
            font-size: 2.5em;
        }
        
        .success-icon {
            text-align: center;
            font-size: 4em;
            margin: 20px 0;
            animation: bounce 0.5s ease-out 0.3s;
        }
        
        @keyframes bounce {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.2); }
        }
        
        .preview-section {
            background: #f8f9fa;
            padding: 30px;
            border-radius: 12px;
            margin: 30px 0;
            text-align: center;
        }
        
        .preview-image {
            max-width: 100%;
            max-height: 400px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            margin: 20px 0;
        }
        
        .image-info {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 20px;
            margin: 20px 0;
        }
        
        .info-box {
            background: white;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .info-label {
            font-size: 12px;
            color: #666;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 5px;
        }
        
        .info-value {
            font-size: 20px;
            font-weight: 600;
            color: #333;
        }
        
        .download-section {
            text-align: center;
            margin: 40px 0;
        }
        
        .download-btn {
            display: inline-block;
            padding: 15px 40px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 50px;
            font-size: 18px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
            margin: 10px;
        }
        
        .download-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }
        
        .secondary-btn {
            display: inline-block;
            padding: 12px 30px;
            background: #e0e0e0;
            color: #333;
            text-decoration: none;
            border-radius: 50px;
            font-size: 16px;
            font-weight: 600;
            transition: all 0.3s ease;
            margin: 10px;
        }
        
        .secondary-btn:hover {
            background: #d0d0d0;
        }
        
        .tips-section {
            background: #f0f4ff;
            padding: 25px;
            border-radius: 12px;
            margin-top: 30px;
            border-left: 4px solid #667eea;
        }
        
        .tips-section h3 {
            color: #667eea;
            margin-bottom: 15px;
        }
        
        .tips-section ul {
            list-style: none;
            padding: 0;
        }
        
        .tips-section li {
            padding: 8px 0;
            padding-left: 25px;
            position: relative;
        }
        
        .tips-section li:before {
            content: "✓";
            position: absolute;
            left: 0;
            color: #667eea;
            font-weight: bold;
        }
        
        .actions {
            text-align: center;
            margin-top: 30px;
            padding-top: 30px;
            border-top: 1px solid #e0e0e0;
        }
        
        @media (max-width: 768px) {
            .container {
                padding: 20px;
            }
            
            h1 {
                font-size: 2em;
            }
            
            .download-btn {
                display: block;
                width: 100%;
                margin: 10px 0;
            }
            
            .secondary-btn {
                display: block;
                width: 100%;
                margin: 10px 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="success-icon">✨</div>
        <h1>Your Photo is Ready!</h1>
        <p style="text-align: center; color: #666; font-size: 18px; margin-bottom: 30px;">
            Your image has been successfully processed and optimized.
        </p>
        
        <div class="preview-section">
            <h2 style="color: #333; margin-bottom: 20px;">Preview</h2>
            <img class="preview-image" src="<?php echo htmlspecialchars($imageData['data']); ?>" alt="Processed Image">
            
            <div class="image-info">
                <div class="info-box">
                    <div class="info-label">Dimensions</div>
                    <div class="info-value"><?php echo htmlspecialchars($imageData['width'] ?? ''); ?>×<?php echo htmlspecialchars($imageData['height'] ?? ''); ?>px</div>
                </div>
                <div class="info-box">
                    <div class="info-label">File Size</div>
                    <div class="info-value"><?php echo htmlspecialchars($imageData['size'] ?? ''); ?> KB</div>
                </div>
                <div class="info-box">
                    <div class="info-label">Format</div>
                    <div class="info-value">JPEG</div>
                </div>
                <div class="info-box">
                    <div class="info-label">Quality</div>
                    <div class="info-value"><?php echo htmlspecialchars($imageData['quality'] ?? '85'); ?>%</div>
                </div>
            </div>
        </div>
        
        <div class="download-section">
            <a href="#" class="download-btn" id="downloadBtn">
                💾 Download Image
            </a>
            <br>
            <a href="#" class="secondary-btn" id="previewBtn" target="_blank">
                🔍 Open in New Tab
            </a>
        </div>
        
        <div class="tips-section">
            <h3>💡 Quick Tips</h3>
            <ul>
                <li>Your image has been optimized for web use and printing</li>
                <li>The file size has been reduced while maintaining quality</li>
                <li>Right-click the download button and select "Save link as..." for more options</li>
                <li>For passport photos, print at actual size (100% scale)</li>
            </ul>
        </div>
        
        <div class="actions">
            <a href="process.php" class="secondary-btn">← Back to Editor</a>
            <a href="index.php" class="secondary-btn">📷 Upload New Image</a>
        </div>
    </div>

    <script>
        // Download functionality
        document.getElementById('downloadBtn').addEventListener('click', function(e) {
            e.preventDefault();
            const imageData = <?php echo json_encode($imageData['data']); ?>;
            const link = document.createElement('a');
            link.href = imageData;
            link.download = 'resized_photo_<?php echo date('Y-m-d_His'); ?>.jpg';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        });
        
        // Preview in new tab
        document.getElementById('previewBtn').addEventListener('click', function(e) {
            e.preventDefault();
            const imageData = <?php echo json_encode($imageData['data']); ?>;
            const newWindow = window.open('', '_blank');
            newWindow.document.write(`
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Image Preview</title>
                    <style>
                        body { margin: 0; display: flex; justify-content: center; align-items: center; min-height: 100vh; background: #f0f0f0; }
                        img { max-width: 100%; height: auto; }
                    </style>
                </head>
                <body>
                    <img src="${imageData}" alt="Preview">
                </body>
                </html>
            `);
            newWindow.document.close();
        });
    </script>
</body>
</html>